'''
Created on Jun 27, 2013

@author: Chris
'''

class Path(object):
    
    # Function: Constructor
    # ---------------------
    # Create a path. You can optionally pass in
    # an older path, and we will copy all the actions!
    def __init__(self, otherPath = None):
        self.actions = []
        if otherPath:
            for action in otherPath.actions:
                self.actions.append(action)
        self.lastState = None
        
    # Function: Set Start State
    # ---------------------
    # If the path is being created from scratch, you
    # should set its start state
    def setStartState(self, state):
        self.lastState = state
        
    # Function: Add Action
    # ---------------------
    # Add an action to the path instance. Also, update
    # the last state in the path.
    def addAction(self, action, newLastState):
        self.actions.append(action)
        self.lastState = newLastState
        
    # Function: Get Last State
    # ---------------------
    # Return the last state in this path
    def getLastState(self):
        return self.lastState
    
    # Function: Get Actions
    # ---------------------
    # Return the actions in this path
    def getActions(self):
        return self.actions
    
    # Function: Get Length
    # ---------------------
    # Return how many actions are in the path
    def getLength(self):
        return len(self.actions)