'''
Created on Jun 27, 2013

@author: Chris
'''

import random

class Puzzle(object): 
    
    SHUFFLES = 200
    ROWS = 3
    COLS = 3
    BLANK_TILE = ' '
    
    # Function: Constructor
    # ---------------------
    # Create a new puzzle state. You can optionally 
    # pass in the pieces as a list of lists. There is 
    # no safegaurd against passing in pieces that violate
    # the ROWS and COLS constants.
    def __init__(self, pieces = None):
        if pieces:
            self.pieces = self.copyPieces(pieces)
            blankRow = self.getBlankRow()
            blankCol = self.getBlankCol(blankRow)
            self.blankCol = blankCol
            self.blankRow = blankRow
        else:
            self.pieces = self.copyPieces(Puzzle.getSolutionPieces())
            self.blankRow = Puzzle.ROWS - 1
            self.blankCol = Puzzle.COLS - 1
            self.shufflePieces()
    
    # Function: Get Pieces
    # ---------------------
    # Returns the list of lists that is used to 
    # represent the pieces of this puzzle state
    def getPieces(self):
        return self.pieces
    
    def printPuzzle(self):
        for row in self.pieces:
            rowString = ''
            for value in row:
                rowString += str(value) + ' '
            print rowString
        print ''
           
    # Function: Get Successor State
    # ---------------------
    # Given an action, creates a new state by
    # applying the action to this state.
    def getSuccessorState(self, action):
        newPuzzle = Puzzle(self.pieces)
        newPuzzle.applyAction(action)
        return newPuzzle
     
    # Function: Get Legal Actions
    # ---------------------
    # Returns all the actions (as strings) that
    # can legally be applied from the current state     
    def getLegalActions(self):
        legalActions = []
        for action in Puzzle.ACTION_MAP:
            dRow, dCol = Puzzle.ACTION_MAP[action]
            newBlankRow = self.blankRow + dRow
            newBlankCol = self.blankCol + dCol
            if self.isLegalPos(newBlankRow, newBlankCol):
                legalActions.append(action)
        return legalActions
    
    # Function: Is Solution
    # ---------------------
    # Returns whether or not this state is a solution
    # to the N-Puzzle problem.
    def isSolution(self):
        counter = 1
        for row in self.pieces:
            for value in row:
                if counter == Puzzle.ROWS * Puzzle.COLS: return True
                if value != counter: return False
                counter += 1
              
              
              
              
               
    #######################################
    # PRIVATE STATIC VARIABLES         
    # You can ignore all these fields :)
    #######################################
    ACTION_MAP = {
        'up': (-1, 0),
        'down': (1, 0),
        'left': (0, -1),
        'right': (0, 1)
    }
    OPPOSITE_MAP = {
        'left':'right',
        'right':'left',
        'up':'down',
        'down':'up'
    }
    SOLUTION_PIECES = None
    
    def copyPieces(self, pieces):
        newPieces = []
        for oldRow in pieces:
            newRow = []
            for value in oldRow:
                newRow.append(value)
            newPieces.append(newRow)
        return newPieces
    
    @staticmethod
    def getSolutionPieces():
        if not Puzzle.SOLUTION_PIECES:
            pieces = []
            counter = 1
            for _ in range(Puzzle.ROWS):
                row = []
                for _ in range(Puzzle.COLS):
                    row.append(counter)
                    counter += 1
                pieces.append(row)
            pieces[Puzzle.ROWS - 1][Puzzle.COLS - 1] = Puzzle.BLANK_TILE
            Puzzle.SOLUTION_PIECES = pieces
        return Puzzle.SOLUTION_PIECES
                
    def applyAction(self, action):
        dRow, dCol = Puzzle.ACTION_MAP[action]
        newBlankRow = self.blankRow + dRow
        newBlankCol = self.blankCol + dCol
        
        movingPiece = self.pieces[newBlankRow][newBlankCol]
        self.pieces[self.blankRow][self.blankCol] = movingPiece
        self.pieces[newBlankRow][newBlankCol] = ' '
        
        self.blankRow = newBlankRow
        self.blankCol = newBlankCol
    
    def isLegalPos(self, row, col):
        if row < 0 or row >= Puzzle.ROWS: return False
        if col < 0 or col >= Puzzle.COLS: return False
        return True
    
    def getBlankCol(self, blankRowIndex):
        blankRow = self.pieces[blankRowIndex]
        return blankRow.index(' ')
    
    def getBlankRow(self):
        for i in range(len(self.pieces)):
            if ' ' in self.pieces[i]:
                return i
        raise Exception('no blank found')
    
    def shufflePieces(self):
        lastAction = 'left'
        for _ in range(Puzzle.SHUFFLES):
            actions = self.getLegalActions()
            opposite = Puzzle.OPPOSITE_MAP[lastAction]
            if opposite in actions:
                index = actions.index(opposite)
                del actions[index]
            action = random.choice(actions)
            lastAction = action
            self.applyAction(action)
    
    def __str__(self):
        string = ''
        for row in self.pieces:
            rowString = ''
            for value in row:
                rowString += str(value) + ' '
            string += rowString
        return string
    
    def __eq__(self, other):
        for r in range(Puzzle.ROWS):
            for c in range(Puzzle.COLS):
                selfValue = self.pieces[r][c]
                otherValue = other.pieces[r][c]
                if selfValue != otherValue: return False
        return True
    
    def __hash__(self):
        return hash(self.__str__())
    
    def __ne__(self, other):
        return not self.__eq__(other)
    
    