/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import smile.Network;
import smile.SMILEException;

public class Inference {
    public static void main(String[] args) {
        Inference.infereceWithBayesianNetwork();
    }

    public static void infereceWithBayesianNetwork() {
        try {
            Network net = new Network();
            net.readFile("network.xdsl");
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("observed.csv"), "UTF-8"));
                String observeLine = br.readLine();
                String[] words = observeLine.split(",");
                String nodeId = words[0];
                String value = words[1];
                net.setEvidence(nodeId, value);
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            net.updateBeliefs();
            double[] values = net.getNodeValue("grade");
            String[] ids = net.getOutcomeIds("grade");
            try {
                FileWriter fw = new FileWriter("query.json");
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write("{\n");
                bw.write("\"grade\":{\n");
                int i = 0;
                while (i < ids.length) {
                    String id = ids[i];
                    double value = values[i];
                    bw.write("\"" + id + "\":" + value);
                    if (i + 1 != ids.length) {
                        bw.write(",");
                    }
                    bw.write("\n");
                    ++i;
                }
                bw.write("}\n");
                bw.write("}");
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SMILEException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void createNetwork() {
        try {
            Network net = new Network();
            net.addNode(18, "Success");
            net.setOutcomeId("Success", 0, "Success");
            net.setOutcomeId("Success", 1, "Failure");
            net.addNode(18, "Forecast");
            net.addOutcome("Forecast", "Good");
            net.addOutcome("Forecast", "Moderate");
            net.addOutcome("Forecast", "Poor");
            net.deleteOutcome("Forecast", 0);
            net.deleteOutcome("Forecast", 0);
            net.addArc("Success", "Forecast");
            double[] aSuccessDef = new double[]{0.2, 0.8};
            net.setNodeDefinition("Success", aSuccessDef);
            double[] aForecastDef = new double[]{0.4, 0.4, 0.2, 0.1, 0.3, 0.6};
            net.setNodeDefinition("Forecast", aForecastDef);
            net.setEvidence("Forecast", "Good");
            net.writeFile("tutorial_a.xdsl");
        }
        catch (SMILEException e) {
            System.out.println(e.getMessage());
        }
    }
}

