class Node():

    def __init__(self, name, cpt, parents):
        self.name = name
        self.cpt = cpt
        self.parents = parents

    def getXml(self):
        string = '<cpt id="' + self.name + '">\n'
        for value in self.cpt.getDomain():
            string += '<state id="' + value + '" />\n'
        string += '<parents>'
        for parent in self.parents:
            string += parent + ' '
        string += '</parents>'
        string += '<probabilities>' + self.getCptString() + '</probabilities>'
        string += '</cpt>\n'
        return string

    def getCptString(self):
        return self._recursiveToString(self.cpt.getTable(), [])

    def _recursiveToString(self, table, parentValues):
        parentIndex = len(parentValues)
        if parentIndex == len(self.cpt.parentDomains):
            return self._getRowString(table, parentValues)
        domain = self.cpt.parentDomains[parentIndex]
        tableString = ''
        for value in domain:
            index = domain.index(value)
            subTable = table[index]
            subString = self._recursiveToString(subTable, parentValues + [value])
            tableString += subString + ''
        tableString += ''
        return tableString

    def _getRowString(self, row, parentValues):
        parentCount = sum(row)
        rowString = ''
        for value in row:
            rowString += str(value) + ' '
        return rowString + ''
