// Dynare routine that solves the neoclassical  model described in the article 
// "Lower Bounds on Approximation Errors to Numerical Solutions of Dynamic 
// Economic Models" by Kenneth L. Judd, Lilia Maliar and Serguei Maliar (2016), 
// Econometrica, forthcoming,(henceforth, JMM, 2016). 

// This version: February 12, 2017. First version: January 20, 2012.


// Block 1. Preamble

var k, theta, c;
varexo e;

parameters alpha, rho, beta, d, gam, sigma, At;

// Load the parameters values
load parameterfile;

set_param_value('gam', gam);
set_param_value('beta', beta);
set_param_value('alpha', alpha);
set_param_value('d', d);
set_param_value('rho', rho);
set_param_value('sigma', sigma);
set_param_value('At', At);

// Block 2. Declaration of the model

model;
c^(-gam) = beta*c(+1)^(-gam)*(1-d + alpha*exp(theta(+1))*At*k^(alpha-1));
c+k = (1-d)*k(-1)+exp(theta)*At*k(-1)^(alpha);
theta = theta(-1)*(rho)+e;
end;

// Block 3. Solving the model

// Numerical initial conditions for the computation of the deterministic steady state 
initval;
theta = 0;
e = 0;
k = 1;
c = At*k^alpha-d*k;
end;

// Specify shocks
shocks;
var e; stderr sigma;
end;

// The model is solved and simulated with the "stoch_simul" command
stoch_simul(nograph, noprint);
//stoch_simul(noprint, nomoments, periods=10001, irf=0); 
//stoch_simul(order=2, pruning, nograph, noprint, nomoments, periods=10001, irf=0);