% "SSE_Expect.m" is a routine for computing the sum of squared approximation 
% errors with errors in expectations (instead of errors in future consumption); 
% see the article "Lower Bounds on Approximation Errors to Numerical  
% Solutions of Dynamic Economic Models" by Kenneth L. Judd, Lilia Maliar 
% and Serguei Maliar (2016), Econometrica, forthcoming,(henceforth, JMM, 2016). 
%
%
% This version: February 12, 2017. First version: January 20, 2012.
% -------------------------------------------------------------------------
% Inputs:    "z"            is the unknown approximation error in current 
%                           consumption c(t), deltac(t);
%            "exp1"         is an expectation function
%            "exp2"         is an expectation finction
%            "k0"            is the beginning-of-the-period capital stock;
%            "c0"            is current-period consumption;
%            "theta0"        is the current-period productivity level;       
%            "k1"           is the end-of-the-period capital stock;
%            "d"            is the depreciation rate;
%            "alpha"        is the capital share in production;
%            "At"            is the normalizing constant in the production
%                           function
%            "gam"          is the coefficient of relative risk aversion
%
% Output:    "y" is         is the sum of squared approximation errors
% -------------------------------------------------------------------------

function [y] = SSE_Expect(z,exp1,exp2,k0,c0,theta0,k1,d,alpha,At,gam)
      
 deltaE0 = 1/(exp1+exp2)* c0^(-gam)*(1+z)^(-gam)-1;
                            % Follows from eq. (A9) in JMM (2016)
 deltak1 = ((1-d)*k0+exp(theta0)*At*k0^alpha-c0*(1+z))/k1-1;
                            % Equation (A6) in JMM (2016)
 y = 10000*(z^2+deltaE0^2+deltak1^2)^0.5;
                            % Sum up the squared errors
 