% Tensor_Grid.m is a routine that constructs a tensor-product grid for the 
% two-dimensional case; see "Lower Bounds on Approximation Errors to Nume-
% rical Solutions of Dynamic Economic Models" by Kenneth L. Judd, Lilia 
% Maliar and Serguei Maliar (2016), Econometrica, forthcoming,(henceforth, 
% JMM, 2016). 
% -------------------------------------------------------------------------
% Inputs:  "M" is a matrix that contains the minimum value, maximum value 
%                and the number of grid points in each of the two dimensions,   
%                x and y; 2-by-3
%
% Outputs: "z" is a two-dimensional tensor-product grid; (#points in 
%                dimension of x) x (#points in dimension of y)-b-2  
% -------------------------------------------------------------------------
% Copyright  2017 by Lilia Maliar and Serguei Maliar. All rights reserved. 
% The code may be used, modified and redistributed under the terms provided 
% in the file "License_Agreement.txt".
% -------------------------------------------------------------------------

function z = Tensor_Grid(M)
    
LBx = M(1,1);                  % Lower bound of variable x
UBx = M(1,2);                  % Upper bound of variable x
NPx = M(1,3);                  % Number of grid points in the dimension of x 

LBy = M(2,1);                  % Lower bound of variable y
UBy = M(2,2);                  % Upper bound of variable y
NPy = M(2,3);                  % Number of grid points in the dimension of y  

vx = linspace(LBx,UBx,NPx)';   % Grid for x
vy = linspace(LBy,UBy,NPy)';   % Grid for y 

% Constructing a tensor-product grid
%-----------------------------------
z = [];
for i = 1:NPy;
    z = [z;[vx ones(NPx,1)*vy(i,1)]]; 
end
    
