#!C:\perl\bin\perl.exe
use strict;
use File::Basename;
use CGI;
use CGI qw/:standard :html3 :form escape unescape/;
use CGI::Carp qw(fatalsToBrowser);
use CGI qw(-private_tempfiles);
$SIG{CHLD}= sub {wait;};

# Make a new directory for the run and set it as current dir:
my $time = time();
my $tmpdir = "C:\\Program Files\\Apache Group\\Apache2\\htdocs\\tmp";
my $dir = $tmpdir."\\$time";
system "mkdir \"$dir\"";
chdir ($dir);

# Send the header and a status message
print "Content-type:text/html\n\n";
print "<Head><Title>CLENCH - Results</Title></Head><Body>";
print "Reading uploaded files<br>";

# Get the CGI params:
my $Submission = new CGI;
my $Organism = $Submission->param('Organism');
my $BkgIdFile = $Submission->param('BkgIdFile');
my @ClusterFiles;
for my $i (1..5){
	if ($Submission->param("ClusterFile"."$i")){
		push (@ClusterFiles, $Submission->param("ClusterFile"."$i"));
	}
}
my $ExpFile = $Submission->param('ExpFile');

my $AnnotationSource = $Submission->param('AnnotationSource');
my $ConvertToSlim = $Submission->param('ConvertToSlim');
my $NumberOfSim = $Submission->param('NumberOfSim');
my $FDRcutoff = $Submission->param('FDRcutoff');
my $DescriptionFile = $Submission->param('DescriptionFile');
my $LevelOfDetail = $Submission->param('LevelOfDetail');

my $PromoterSource = $Submission->param('PromoterSource');

# Get the BkgIdFile, ClusterFile and ExpFile uploaded by the user:
my $Bfile = &StoreUploadedFile ($dir, $BkgIdFile);
my $Cfile = &HandleClusterList ($dir, \@ClusterFiles);
my $Efile = &StoreUploadedFile ($dir, $ExpFile);
my $Dfile = &StoreUploadedFile ($dir, $DescriptionFile) if ($DescriptionFile);

print "Done reading files<br>";

# Make the name for the result link:
my $Result = $Cfile;
$Result =~ s/\.txt|\.xls/\.html/;
$Result =~ s/ClusterList/index/;

# Tell the user and start the job:
print "Starting clench run in /tmp/$time<br>\n";
print "your results will be at:\n";
print "http://$ENV{SERVER_NAME}/tmp/$time/ when Clench finishes<br>\n";
$|=1;
print "<PRE>";
my $return = system  "\"C:\\Scripts\\Clench_plugin.pl\" "
		."Organism $Organism "
		."BkgIdFile \"$Bfile\" "
		."ClusterFile \"$Cfile\" "
		."ExpFile \"$Efile\" "
		."AnnotationSource $AnnotationSource "
		."ConvertToSlim $ConvertToSlim "
		."NumberOfSim $NumberOfSim "
		."FDRcutoff $FDRcutoff "
		."LevelOfDetail $LevelOfDetail "
		."PromoterSource $PromoterSource";
print "</PRE>";
if ($return == 0){
	print "<P><a href=http://$ENV{SERVER_NAME}/tmp/$time/$Result>",
      "http://$ENV{SERVER_NAME}/tmp/$time/$Result</a><br>\n";
}

print "</body>";

###############################################################################
sub StoreUploadedFile {
###############################################################################
	my ($wdir, $Name) = @_;
	open (FILE, ">"."$wdir"."\\".basename($Name)) or warn "cant write $Name";
	while (<$Name>){
		$_ =~s/\n|\r//g;
		print FILE $_,"\n";
	}
	close FILE;
	print "&nbsp;&nbsp; - Read, $Name<br>";
	return basename("$wdir"."\\"."$Name");
}
###############################################################################
sub HandleClusterList {
###############################################################################
	my ($wdir, $FileListRef) = @_;
	my $ListFile;
	if (scalar @{$FileListRef} > 1){
		open (LIST, ">"."$wdir"."\\ClusterList.txt") or warn "cant write list";
		foreach my $File (@{$FileListRef}){
			$File = &StoreUploadedFile ($wdir, $File);
			print LIST "$File"."\n";
		}
		close LIST;
		$ListFile = "ClusterList.txt";
	}else{
		$ListFile = &StoreUploadedFile ($wdir, $$FileListRef[0]);
	}
	return $ListFile;
}