# This program loads a GO database from go_<YYYYMM>-<DATASET><tables>:

use strict;
use DBI;
use Win32::Console;

if (!$ARGV[0]){
   print "usage: DirOfMyGOTables\n";
   exit;
}

my $Dir = $ARGV[0];
if (!-d $Dir){
	print "$Dir is not a directory\n";
	exit;
}

# Read in the files in the directory:
chdir($Dir);
my @Files = `dir /B`;
my %List;
foreach my $file (@Files){
	chomp $file;
	$file=~s/\.sql|\.txt//;
	$List{$file}=$file;
}

# Start the database work:

my $DbName = AskDbName();
my ($username,$password) = GetUserAndPw();

my $dbh=DBI->connect("DBI:mysql:",$username,$password, {RaiseError=>1}) or
die "Couldn't connect:".DBI->errstr();

$dbh->do("create database if not exists $DbName");
$dbh->do("use $DbName");

my $tables = "show tables";
my $sth = $dbh->prepare($tables);
$sth->execute();
my %Exists;
while (my $T = $sth->fetchrow){
	$Exists{$T}=1;
}

foreach my $K(keys %List){
	$Dir =~s/\\/\//g;
	my $TableFile = $Dir."/".$List{$K}.".sql";
	my $DataFile = $Dir."/".$List{$K}.".txt";
	my @Sql;
	my $sth;

	open (File, $TableFile) or die "Cant open $TableFile\n";
	while (my $line = <File>){
		next if $line=~m/^--|^#/;
		next if $line=~m/^\n|^$/;
		next if $line=~m/\/*!/;
		next if $line=~m/Drop Table/i;
		$line =~s/`//g;
		chomp $line;
		push (@Sql, "$line");
	}
	close File;

	# Drop the table:
	if (defined $Exists{$List{$K}}){
		my $qd = "drop table $List{$K}";
		$sth = $dbh->prepare($qd);
		$sth->execute();
		print "Dropped table $List{$K}\n";
	}

	# Make a new table:
	my $qt = join ("\n",@Sql);
		$sth = $dbh->prepare($qt);
		$sth->execute();
	if ($DBI::err){
  		my $err = $dbh->errstr;
    	print "$qt\n";
  	}
  	else {print "Made table $List{$K}\t";}

  	# Load data into the table:
  	my $ql = "load data infile '$DataFile' into table $List{$K}";
		$sth = $dbh->prepare($ql);
		$sth->execute();
	if ($DBI::err){
  		my $err = $dbh->errstr;
    	print "$ql\n";
  	}
  	else {print " ... Loaded data in $List{$K}\n";}
}
$dbh->disconnect;
exit;
##########################################################################
sub GetUserAndPw {
##########################################################################
	my ($username, $password);
    my $StdIn = new Win32::Console(STD_INPUT_HANDLE);
       $StdIn->Mode(ENABLE_PROCESSED_INPUT);
	print " * Please enter a username for GO: ";
  	while (my $Data = $StdIn->InputChar(1)) {
       if ($Data eq "\r"){ last;}
       $username .=$Data;
       print "$Data";
 	}
	print "\n * Please enter the password: ";
  	while (my $Data = $StdIn->InputChar(1)) {
       if ($Data eq "\r"){ last;}
	   elsif ($Data eq "\ch") {
        	if( "" ne chop( $password )) {
                 print "\ch";
            }
            next;
        }
       $password .=$Data;
       print "*";
 	}
 	print "\n";
	chomp $username; chomp $password;
	return ($username,$password);
}
##########################################################################
sub AskDbName {
##########################################################################
	print " * Choose a name for your local GO database: ";
	my $DbName = <STDIN>;
	chomp $DbName;
	return $DbName;
}