@echo off

echo Windows NT 4.0 to Windows 2000 upgrade preparation procedure for:
echo         Dell PERC 2, 2/Si, 3/Si, 3/Di RAID Controllers
echo.
echo Please read the following notes carefully.
echo.
echo This upgrade procedure must be run prior to attempting to upgrade
echo from Windows NT 4.0 to Windows 2000. The Windows 2000 upgrade process
echo will prevent you from upgrading from Windows NT 4.0 to Windows 2000
echo unless you have run this procedure.
echo.
echo This upgrade procedure automatically replaces the Dell PERC 2, 2/Si,
echo 3/Si, and 3/Di RAID controller device drivers.  However, you must
echo manually de-install the RAID controller management software before
echo you begin the upgrade.
echo.
pause
echo.
echo When this upgrade procedure completes you will still be able to boot to
echo Windows NT 4.0, but you will not be able to use the RAID controller
echo management software.  Do not reinstall the management software until
echo you have completed the Windows 2000 upgrade.
echo. 
echo If you have run this upgrade preparation procedure but do not wish to
echo upgrade to Windows 2000 you must re-install the original NT 4.0 drivers
echo through Control Panel, SCSI Adapters. Select the Drivers tab, select the
echo appropriate Dell RAID controller and press Add. Select Have Disk,
echo and insert the original NT 4.0 drivers diskette for your controller when
echo prompted. Reboot the system and you will be able to manage your controller.
echo.

setlocal
..\upgrade\choice Do you wish to continue with the Dell PERC 2 Windows 2000 upgrade 
if %ERRORLEVEL% EQU 2 goto :declined

echo.

REM
REM Working directories/files
REM
set targetdir=%systemroot%\system32\drivers
set infdir=%systemroot%\inf
set catdir=%systemroot%\system32
set sysdir=%systemroot%\system32
set w2kinf=perc2.inf
set tmpdir=%TEMP%
set tmpfile=%tmpdir%\perc2inf
set lstfile=%tmpfile%.lst
set errfile=%tmpfile%.err

REM
REM Work variables
REM
set ReplInf="Y"

REM ---------------------------------------------------------------------
REM Check the required core set of driver images exist.
REM Note that the xxxport.sys driver only exists for V2.0 systems.
REM Similarly the xxxsa.sys driver only exists for V1.0 and V1.1 systems.
REM ---------------------------------------------------------------------

for %%i in ( afascsi.sys afadisk.sys afacomm.sys) do if not exist %targetdir%\%%i call :error %%i & goto :exit

REM ---------------------------------------------------------------------
REM Check whether there is an INF file present or not. If so, replace
REM it with the Windows 2000 version.
REM ---------------------------------------------------------------------

REM
REM Delete any old temporary files. If that fails, fail the
REM upgrade.
REM
call :DelLstFiles
if exist %lstfile% goto :DelLstError

REM
REM Look for all occurances of the  PCI line and create a list of filenames
REM
for %%i in (%infdir%\oem*.inf) do findstr /M /L /C:"perc2_Inst, PCI\VEN_1011&DEV_0046&SUBSYS_13649005" %%i  1>> %lstfile% 2>> %errfile%

REM
REM If we didn't get an output file then nothing to do ...
REM
if not exist %lstfile% goto :DoneInf

REM
REM Delete any corresponding pnf files we found.
REM
for /F %%i in (%lstfile%) do if exist %infdir%\%%~ni.pnf del  %infdir%\%%~ni.pnf
if defined VERBOSE for /F %%i in (%lstfile%) do echo %%i

REM
REM And replace (or delete) the inf file with the one we want.
REM
for /F %%i in (%lstfile%) do call :ReplaceInf %%i

REM
REM Finally delete our temporary work files.
REM
if not defined DEBUG call :DelLstFiles

:DoneInf
REM ---------------------------------------------------------------------
REM Now delete all the driver image files we find in the drivers directory.
REM This step also replaces any V2.0 driver images found.
REM Then copy the miniport onto the system.
REM Then copy the management device inf file onto the system.
REM Then copy the co-installer onto the system.
REM Finally copy the cat file to the system32 directory.
REM Note that we need to install the miniport as AfaScsi as that is the
REM service associated with the adapter right now.
REM ---------------------------------------------------------------------
for %%i in (afasa.sys afadisk.sys afacomm.sys afaport.sys perc2.sys) do if exist %targetdir%\%%i del %targetdir%\%%i
for %%i in (afascsi.sys) do copy ..\upgrade\%%i %targetdir%\%%i
for %%i in (perc2.sys perc2hib.sys) do copy %%i %targetdir%\%%i
for %%i in (perc2mgt.inf) do copy %%i %infdir%\%%i
for %%i in (perc2cin.dll perc2evt.exe) do copy %%i %sysdir%\%%i
for %%i in (perc2.cat) do copy %%i %catdir%\%%i

REM ---------------------------------------------------------------------
REM Now setup the registry to the miniport and disable all the class driver files.
REM ---------------------------------------------------------------------
echo.
echo Performing Registry updates. The following messages are normal.
echo.
..\upgrade\regini ..\upgrade\w2kupgrd.ini

REM ---------------------------------------------------------------------
REM All done successfully.
REM ---------------------------------------------------------------------
echo.
echo The Windows NT 4.0 to Windows 2000 upgrade preparation was SUCCESSFUL
echo.
echo You may now restart the Windows 2000 upgrade.
echo.
echo If you no longer wish to run the Windows 2000 upgrade, re-install the
echo original NT 4.0 drivers as described above and in your RAID controller
echo documentation.
goto :exit

REM
REM --------
REM Routines
REM --------
REM

REM
REM Routine: ReplaceInf
REM If we've not already replaced an INF for
REM our adapter, replace the first INF found
REM that matches. Any subsequent INF is deleted.
REM
REM %1 = OEM Inf file name
REM
:ReplaceInf
if %ReplInf% == "N" goto :DoDelInf
xcopy %w2kinf% %1 /Q /R /K  > ./nul
set ReplInf="N"
goto :EOF
:DoDelInf
del %1
goto :EOF

REM
REM Routine: DelTmpFile
REM ------------------
REM Delete any old temporary work file just
REM in case the user runs this procedure more
REM than once.
REM
:DelLstFiles
if exist %lstfile% del %lstfile%
if exist %errfile% del %errfile%
goto :EOF


REM
REM --------------
REM Error Handlers
REM --------------
REM

:DelLstError
echo.
echo The Windows NT 4.0 to Windows 2000 upgrade procedure FAILED
echo.
echo Unable to remove temporary file: %lstfile%
echo This utility must be run from the Administrator account.
goto :exit

:error
echo.
echo The Windows NT 4.0 to Windows 2000 upgrade procedure FAILED
echo.
echo The required driver image %targetdir%\%1 was not found.
echo.
echo Please ensure you run this upgrade procedure when booted from the
echo Windows NT 4.0 installation to be upgraded
goto :EOF

:declined
echo.
echo The Windows NT 4.0 to Windows 2000 upgrade procedure was CANCELLED
echo.
echo No changes have been made to the system
goto :exit

:exit
echo.
pause
endlocal
