%======================================================
%  Matlab Demonstration of the LP formulation of the
%  Max-Flow example
%
%  Output
%          x(1:9): flow on edge
%          y(1:5): levels of each state (y(6)=0)
%  
%  Details can be found from Example 2.4 in Sect. 2.2 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Set the edge cost vector
    c=[0;0;0;0;0;0;0;0;1];
%  The node-action incident matrix
    A=zeros(6,9);
    A(1,1)=1;A(2,1)=-1;% #1 edge from state 1 to state 2;
    A(1,2)=1;A(3,2)=-1;% #2 edge from state 1 to state 3;
    A(2,3)=1;A(4,3)=-1;% #3 edge from state 2 to state 4;
    A(2,4)=1;A(5,4)=-1;% #4 edge from state 2 to state 5;
    A(5,5)=1;A(2,5)=-1;% #5 edge from state 5 to state 2;
    A(3,6)=1;A(5,6)=-1;% #6 edge from state 3 to state 5;
    A(4,7)=1;A(6,7)=-1;% #7 edge from state 4 to state 6;
    A(5,8)=1;A(6,8)=-1;% #8 edge from state 5 to state 6;
    A(6,9)=1;A(1,9)=-1;% #9 edge from state 6 to state 1;
%   remove redundant row #6
    A=A(1:5,:);
%   add upbound constraint and form A in the LP standard form
    A=[A zeros(5,9);eye(9) eye(9)];
%  Set edgeflow upbound and the LP right-hand-side in standard form
    u=[6;11;12;5;5;10;13;4;66];
    b=[zeros(5,1);u];
%  Set the overall objective coeffient vector in standard form
    c=[c;zeros(9,1)];
%  Call LP solver
    [x,y]=HSDLPsolver(A,b,-c);
%