%======================================================
%  Matlab Demonstration of the LP formulation of the
%  Maze Runner example
%
%  Input   gamma: doscount factor
%  Output
%          y: cost-to-go values of each state
%          x: expect fluxes of action taking
%  
%  Details can be found from Example 2.8 in Sect. 2.2 
%  and homework problem 2.18 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Immediate action cost vector
    c=[0;0;0;0;0;0;0;0;1;0];
%  Probability distribuion of each action
    P=zeros(6,10);
    P(2,1)=1; % #1 action of state 1 leads to state 2;
    P(3,2)=1/4;P(4,2)=1/4;P(5,2)=1/4;P(6,2)=1/4;% #2 action of state 1
    P(3,3)=1; % #3 action of state 2 leads to state 3;
    P(4,4)=1/3;P(5,4)=1/3;P(6,4)=1/3;% #4 action of state 2;
    P(4,5)=1; % #5 action of state 3 leads to state 4;
    P(5,6)=1/2;P(6,6)=1/2; % #6 action of state 3;
    P(5,7)=1; % #7 action of state 4 leads to state 5;
    P(5,8)=1/4;P(6,8)=4/5; % #8 action of state 4;
    P(6,9)=1; % #9 action of state 5 leads to state 6;
    P(1,10)=1; % #10 action of state 6 leads to state 1;
%  State-Action Incident Matrix
    S=zeros(6,10);
    S(1,1)=1;S(1,2)=1;% #1&2 actions belong to state 1;
    S(2,3)=1;S(2,4)=1;% #3&4 actions belong to state 2;
    S(3,5)=1;S(3,6)=1;% #5&6 actions belong to state 3;
    S(4,7)=1;S(4,8)=1;% #7&8 actions belong to state 4;
    S(5,9)=1;         % #9 action belongs to state 5;
    S(6,10)=1;        % #10 action belongs to state 6;
%  Set b
    b=ones(6,1);
%  Call LP solver
    gamma=0.9;
    [x,y,s]=HSDLPsolver(S-gamma*P,b,c);
%