%======================================================
%  Matlab Demonstration of the LP formulation of the
%  SVM example
%
%  Input: A data points, each column represtns a point in class 1
%         B data points, each column represent a point in class 2
%  Output
%          y(1:2): slope vector of line
%          y(3)  : intercept
%          y(4...)  : margin
%  
%  Details can be found from Example 2.6 in Sect. 2.2 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Check the number of data points for A and B
    [m,na]=size(A);
    [m,nb]=size(B);
    figure(1);
    hold on ;
    plot(A(1,1:na),A(2,1:na),'*r');        
    plot(B(1,1:nb),B(2,1:nb),'ob');
%  Set the LP constraint matrix
    AA=[-A B zeros(m,1);-ones(1,na) ones(1,nb) 0;ones(1,na+nb) 1];
%  Set the fixed margin vector
    cc=[-ones(na+nb,1);0];
%  Set the objective to reduce 
    bb=[zeros(m+1,1);1];
%  Call LP solver
    pause(5);
    [x,y]=HSDLPsolver(AA,bb,cc);
%  Plot seperating line
    y1=(0.5*y(1)-y(3))/y(2);
    y2=(-1.5*y(1)-y(3))/y(2);
    line([-0.5  1.5] , [y1 y2]);
    hold off
%