%======================================================
%  Matlab Demonstration of the LP formulation of the
%  Transportation example
%
%  Output
%          x: route shipments
%          y: shadow prices of supply and demand
%             (last demand has zero price)
%  
%  Details can be found from Example 2.3 in Sect. 2.2 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Immediate action cost vector
    c=[12;13;4;6;6;4;10;11;10;9;12;14];
%  Set constraint matrix
    A=zeros(7,12);
    A(1,1:4)=ones(1,4); % supply 1 to all demands
    A(2,5:8)=ones(1,4); % supply 2 to all demands
    A(3,9:12)=ones(1,4);% supply 3 to all demands
    A(4:7,1:4)=eye(4);  % from supply 1
    A(4:7,5:8)=eye(4);  % from supply 2
    A(4:7,9:12)=eye(4); % from supply 3
%  Set the right-hand-vector 
    b=[500;700;800;400;900;200;500];
%  remove redundant constraint (the last one)
   A=A(1:6,:); b=b(1:6);
%  Call LP solver
    [x,y,r]=HSDLPsolver(A,b,c);
%