%======================================================
%  Matlab Demonstration of the LP formulation of the
%  World-Cup auction example
%
%  Output
%          x(1:5): order-fill decision on each order
%          y(1:5): values of each state
%  
%  Details can be found from Example 2.7 in Sect. 2.2 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Set the edge cost vector
    c=[0.75;0.35;0.4;0.95;0.75;-1];
%  The state-order matrix
    A=zeros(5,5);
    A(1,1)=1;A(2,1)=1;A(3,1)=1;% #1 order on states 1,2 and 3;
    A(4,2)=1;                  % #2 order on state 4;
    A(1,3)=1;A(3,3)=1;A(5,3)=1;% #3 order on states 1,3 and 5;
    A(1,4)=1;A(2,4)=1;A(3,4)=1;A(4,4)=1;% #3 order on states 1,2,3 and 4;
    A(2,5)=1;A(4,5)=1;         % #5 order order on states 2 and 4;
%   set A matrix of the LP in standard form
    A=[A -ones(5,1); eye(5) zeros(5,1)];
%   add slack matrix
    A=[A eye(10)];
%  Set uplimit of each order and the LP right-hand-side in standard form
    q=[10;5;10;10;5];
    b=[zeros(5,1);q];
%  Set the overall objective coeffient vector in standard form
    c=[c;zeros(10,1)];
%  Call LP solver
    [x,y,r]=HSDLPsolver(A,b,-c);
    y=-y(1:5);
%