%======================================================
%  Matlab Demonstration of LP of resource allocation
%      max   c'*x
%      s.t.  Ax <= b, 0 <= x <= 1.
%
%  Input 
%      A: inequality constraint matrix.
%      b(>0): inequality right-hand column vector
%      c: objective coefficient vector
%      K: boosting (positive) integer
%  Output
%          x: production level
%          p: dual prices of resources
%
%  Algorithm: boosted dual stochastic sug-gradient method 
%  Details can be found from Sect. 3.5 of Chap. 3 of 
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
function [x,y] = fastOLPK(A,c,b,K);
% Set parameters
%
 [m,n] = size(A);
 br= K*b; % Set the initial remaining inventory
 dk=b/n;
 step=1/sqrt(K*n); % Set the step-size
%
 x = zeros(n,1); % Set initial primal solutions
 y = zeros(m,1); % Set initial dual solutions
% y = A(:,1:m)'\c(1:m);
%
% Start the outer loop
 for k=1:K;
  p=randperm(n); %Randomly permute variable-order in each round
%
% Start the inner loop
  for i=1:n,
   ii=p(i);
   aa=A(:,ii);
   %
   % Set the primal increment
   xk = (sign(c(ii)-aa'*y)+1)/2;
   %
   % Update the dual soluton
   y=max(0,y+step*(xk*aa-dk)); 
   %
   % Update the remaining inventory and primal solution
   if min(br-xk*aa) >= 0,
       br=br-xk*aa;
       x(ii)=x(ii)+xk;
   end
   % Adjust the average inventory for the remaining customers
   % dk=br/(n*(K-k+1)-i+1);
   %
  end;
 end;
  x=x/K; % Output the primal solution
%



