%======================================================
%   One-Iteration Demonstration of the Dual 
%   Affine-Scaling Algorithm for computing the analytic 
%   center of feasible region {y: A'*y<=c}
%  Input 
%      A: m x n matrix, c: rhs vector,
%      y0: initial and interior feasible solution for dual
%      iter (= 0): iteration count
%
%   Details can be found in Sect. 5.4 (analytic center)
%   8.5 (affine-scaling), and 
%   12.7 (interior ellipsoidal-trust region) of
%   L&Y, Linear and nonlinear programming, 5th edition
%
%   Highlight: exibit quadratic convergence when the 
%              iterate is close to the analytic center
%  
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    y=y0;
end;
s        =c-A'*y;
d        =ones(n,1)./s;
dy       =-(diag(d)*A')\ones(n,1);
ds       =-A'*dy;
ps       =d.*ds;
normps   =norm(ps)
if (normps < 1)
    y  = y+dy;
else
    y  = y+(0.5/normps)*dy;
end;
iter   =iter + 1;
%
