%======================================================
%   One-Iteration Demonstration of the Primal 
%   Affine-Scaling Algorithm for computing the analytic 
%   center of feasible region {x: Ax=b, x>=0}
%  Input 
%      A: m x n matrix, b: rhs vector,
%      x0: initial and interior feasible solution for primal
%      iter (= 0): iteration count
%
%   Details can be found in Sect. 5.4 (analytic center)
%   8.5 (affine-scaling), and 
%   12.7 (interior ellipsoidal-trust region) of
%   L&Y, Linear and nonlinear programming, 5th edition
%
%   Highlight: exibit quadratic convergence when the 
%              iterate is close to the analytic center
%  
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    x=x0;
end;
% Apply the (primal) affine-scaling-projection
y     = -(diag(x)*A')\ones(n,1);
s     = -A'*y;
% assemble the scaled gradient projection direction
px     = x.*s-ones(n,1);
normpx = norm(px)
%
if (normpx < 1)
    x  = x-x.*px;
else
    x  = x-(0.5/normpx)*(x.*px);
end;
iter   =iter + 1;
%


