%======================================================
%   One-Iteration Demonstration of the Dual 
%   Potential-Reduction Algorithm for dual LP 
%      maximize    b'*x
%      subject to  A'y+s = c, s >= 0
%
%  Input 
%      A: constraint matrix in standard primal form
%      b: constraint right-hand column vector
%      c: objective column vector
%      y0: interior feasible point
%      z: an upper bound on maximal objective value
%      rho: (optional) potential parameter >= sqrt(n) 
%      alpha: (optional) step-size
%   
%   Details can be found in Sect. 5.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    y=y0;
    s      =c-A'*y;
end;
if exist('alpha') ~= 1
   alpha = 0.95;
end;
if exist('rho') ~= 1
   rho = n^2;
end;
gap      =z-b'*y;
potenf   =rho*log(gap)-sum(log(s))
d        =ones(n,1)./s;
(A*diag(d.*d)*A')\[b A*d];
dy1=ans(:,1);dy2=ans(:,2);
dy       =(rho/gap)*dy1-dy2;
pk       =d.*(A'*dy);
normpk   =norm(pk)
%
% Update primal solution 
%
while normpk < .75,
  x      =(gap/rho)*d.*(ones(n,1)+pk);
  gap    =s'*x;
  z      =gap + b'*y;
  dy     =(rho/gap)*dy1-dy2;
  pk     =d.*(A'*dy);
  normpk =norm(pk)
end;
%
%  Update the dual solution
%
y     =y+(alpha/normpk)*dy;
s     =c-A'*y;
iter  =iter+1;
%






