%======================================================
%   One-Iteration Demonstration of the Primal 
%   Path-Following Algorithm for LP 
%      maximize    c'*x
%      subject to  A x = b, x >= 0
%
%  Input 
%      A: m x n matrix, b: rhs vector, c: obj vector
%      x0: initial (near)central-path solution for primal
%      y0: initial (near)central-path solution for dual
%      iter (= 0): iteration count
%   
%   Details can be found in Sect. 5.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    x=x0;
    y=y0;
    s=c-A'*y;
end;
mu     = x'*s/n
% theoretical reduction
% gamma  =(1-1/(3*sqrt(n)));
% practical reduction
gamma  =(1-1/3);
%
gk     = c - (gamma*mu)*ones(n,1)./x;
Xgk    = diag(x)*gk;
Ak     = A*diag(x);
yk     = Ak'\Xgk;
pk     = Xgk-Ak'*yk;
normpk = norm(pk)
y      = yk;
s      = c-A'*y;
x      = x.*(ones(n,1)-pk);
iter   =iter + 1;


