%======================================================
%   One-Iteration Demonstration of the Primal-Dual 
%   Path-Following Algorithm for LP 
%      maximize    c'*x
%      subject to  A x = b, x >= 0
%
%  Input 
%      A: m x n matrix, b: rhs vector, c: obj vector
%      x0: initial (near)central-path solution for primal
%      y0: initial (near)central-path solution for dual
%      iter (= 0): iteration count
%   
%   Details can be found in Sect. 5.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    x=x0;
    y=y0;
    s=c-A'*y;
end;
mu     = x'*s/n
% theoretical reduction
% gamma  =(1-1/(3*sqrt(n)));
% practical reduction
gamma  =(1-1/3);
%
rk     = gamma*mu*ones(n,1)-x.*s;
Ak     = A*diag(x./s);
Mk     = Ak*A';
dy     = -Mk\(A*(rk./s));
ds     = -A'*dy;
dx     = rk./s - (x.*ds)./s;
% 
y      = y+dy;
s      = s+ds;
x      = x+dx;
iter   = iter+1
%
