%======================================================
%   One-Iteration Demonstration of the Primal-Dual 
%   Potential-Reduction Algorithm for LP pair 
%    minimize    c'*x                 max  b'*y
%    subject to  A x = b, x >= 0      s.t. A'y<=c
%
%  Input 
%      A: m x n matrix
%      x0: initial interior feasible point for the primal
%      y0: initial interior feasible point for the dual
%      iter (= 0): iteration count
%      rho: (optional) potential parameter >= n+sqrt(n) 
%      alpha: (optional) step-size
%   
%   Details can be found in Sect. 5.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    x=x0;
    y=y0;
    s=c-A'*y;
end;
if exist('alpha') ~= 1
   alpha = 0.95;
end;
if exist('rho') ~= 1
   rho = n;
end;
potential=(n+rho)*log(x'*s)-ones(n,1)'*log(x.*s)
mu     = x'*s/n;
gamma  = n/(n+rho);
rk     = gamma*mu*ones(n,1)-x.*s;
Ak     = A*diag(x./s);
Mk     = Ak*A';
dy     = -Mk\(A*(rk./s));
ds     = -A'*dy;
dx     = rk./s - (x.*ds)./s;
% Conservative step size
%theta  = min(x.*s)/((rk./x)'*(rk./s));
%theta  = alpha*sqrt(theta);
%
% Aggressive step size
theta  = min([dx./x;ds./s]);
theta = abs(alpha/theta);
%
y      = y+theta*dy;
s      = s+theta*ds;
x      = x+theta*dx;
potential=(n+rho)*log(x'*s)-ones(n,1)'*log(x.*s)
iter   = iter+1
%


