%======================================================
%   Implementation of ELLIPSOID METHOD ALGORITHM for
%    max  2x1 + x2
%    s.t. (x1,x2)<= 1, (x1,x2)>=0
%    Details can be found at the end of Sect. 5.3 of
%    L&Y, Linear and nonlinear programming, 5th edition
%======================================================

% INSTRUCTIONS:
% 1. Run the code and wait for the first plot to appear
% 2. Embed the graph in the Matlab main Command Window 
%     by clicking on the arrow at the top right corner
%     of the graph window.
% 3. Press enter to plot the initial ellipsoid and keep
%     doing so to plot the rest of the ellipsoids
% 4. type exit to stop the run
%
% IMPORTANT: Make sure you have the plot_ellip function
% in your library.

% Clean previous variables
clear; clc;
% Convergence error (it could be made larger to decrease
% the amount of iterations and plotted ellipsoids)
error=0.03;

% Objective Function Coefficients (MAX Form)
C=[2;1];
% Constraint Matrix A and rhs Vector b 
% IMPORTANT: The signs of A and b must be consistent 
% with the Ax>=b form. 
A=[-1 0;0 -1;1 0;0 1];
b=[-1;-1;0;0];

% Plotting Feasible Region
% (this is the only graph that is not self plotted, thus
% if the constraints change, these vectors should also
% change to be consistent with the new problem)
figure; plot([0,1,1],[1,1,0],'r'); axis([-2,3,-1,3]); hold on;

% Plotting the Objective Contour
contbeg=-1/4;
contpos=1;
plot([contbeg,(contpos-C(2)*contbeg)/C(1)],[(contpos-C(1)*contbeg)/C(2),contbeg],'g'); hold on;
% Plotting axis
plot([zeros(1,2)],[-3,3],'k',[-3,3],[zeros(1,2)],'k'); hold on;
input('');

% Initial Ellipsoid
dim=length(C);
X=[0.2;1.2];
B=2.5*eye(dim);
% Displays data about the initial ellipsoid
disp(' '); disp(' INITIAL ELLIPSOID'); disp(' ');
disp(' Y^0'); disp(X);
disp(' B^0'); disp(B); 
% Plotting the initial ellipsoid
plot_ellip(X,B,'k','*k')
input('');
% Constants
T=1/(dim+1);
D=dim^2/(dim^2-1);
S=2*T;
% Cycling constants
VC=zeros(length(b),1);
OC=0;
It=0;
ObIt=0;
stop=error+1;

% Optimality claim
while stop>=error;
    FV=A*X; 
    ans=0; 
    while ans==0;
        % Checking for feasibility
        if FV>=b;
            ans=1;
        else
            % Selecting the violated constraint
            for n=1:length(VC)
                if FV(n,1)>=b(n,1);
                    VC(n,1)=0;
                else
                    VC(n,1)=1;
                end
            end
            [mv,vc]=max(VC);
            aj=A(vc,:);
            % Ellipsoid after feasibility cut
            X=X+(T/((aj*B*aj.')^(1/2))*(B*aj.'));
            B=D*(B-S*(B*aj.'*aj*B)/(aj*B*aj.'));
            % Plotting the feasibility ellipsoids (red)
            plot_ellip(X,B,'r','*r')
            VC=zeros(length(b),1);
            FV=A*X;
            It=It+1;
            input('');
        end
    end
% Computing objective value and error
   ObIt=ObIt+1;
    if ObIt==1;
        u(ObIt)=C'*X;
        stop=error+1;
    elseif ObIt>1;
        u(ObIt)=C'*X;
        stop=abs(u(ObIt)-u(ObIt-1));
    end
% Ellipsoid after objective cut
X=X+(T/((C'*B*C)^(1/2))*(B*C));
B=D*(B-S*(B*C*C'*B)/(C'*B*C));
% Plotting the objective ellipsoids (blue)
plot_ellip(X,B,'b','*b')
input('');
end

% Displays the Optimal Solution for the 
% specified convergence error
disp(' B^opt'); disp(B);
disp(' '); disp(' Optimal Solution'); X
disp(' '); disp(' Error'); disp(error);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_ellip(Y,B,col,cen)
%
%PLOT_ELLIP - PLOTS AN ELLIPSOID
%used by ellip_method_LP_graph.m
%
%Function(Y,B,col,cen)
%
%Y:    Center of the ellipsoid - (2x1) Vector 
%B:    Shape and size of the ellipsoid - (2x2) Matrix 
%col:  Ellipsoid plot color  
%cen:  Type of marker and color for the ellipsoid center
%
%e.g.  plot_ellip(X,B,'k','*k')
%
B1=inv(B);
a2=1/B1(1,1);
b2=1/B1(2,2);
a=a2^(1/2);
b=b2^(1/2);
% Independent variable vector(for larger ellipsoids, the boundaries of the vector must be expanded)
res=0.0005;
bound=5;
X2=-bound:res:bound;
y1=Y(1);
y2=Y(2);
pos=0;
for m=1:length(X2);
x2=X2(m);
% Generates points for coordinate aligned ellipsoids
if B(1,2)==0;
    x11=a/b*(real((b2-(x2-y2)^2)^(1/2)))+y1;
    x12=a/b*(-real((b2-(x2-y2)^2)^(1/2)))+y1;
% Generates points for coordinate every other ellipsoid
else
    c=1/B1(1,2);
    d=1/B1(2,1);
    x11=(a*real((a2*b2*(c+d)^2*(x2-y2)^2+4*(b2-(x2-y2)^2)*(c*d)^2)^(1/2))-b*(a2*(c+d)*(x2-y2)-2*c*d*y1))*(1/(2*b*c*d));
    x12=(-a*real((a2*b2*(c+d)^2*(x2-y2)^2+4*(b2-(x2-y2)^2)*(c*d)^2)^(1/2))-b*(a2*(c+d)*(x2-y2)-2*c*d*y1))*(1/(2*b*c*d));
end
if (x11-x12)>0.0001
    pos=1+pos;
    X11(pos)=x11;
    X12(pos)=x12;
    X22(pos)=x2;
end
end
plot(X11,X22,col,X12,X22,col,y1,y2,cen); hold on;
%
end% end of the plot function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





    
    
  
