%======================================================
%  Matlab Demonstration of
%  Objective-Guided Rank-Reduction of SDP Relaxation for
%  the 4-node chain localization example
%
%  Need to call public SDP solver DSDP (64 bits)
%
%  Output: centers positions of n spheres.
%  
%  Details can be found in HW6.17 and Sect. 6.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%  Zero or Trace-objective
%   C=0*dvec(eye(3));
%  Tensegrity-objective proposed in the textbook
    a=[0;0;1];
    C=-dvec(a*a');
% Set constraints to call SDP solver
    b=1;
    a=[1;0;0];
    A=dvec(a*a');
    b=[b;1];
    a=[1;-1;0];
    A=[A dvec(a*a')];
    b=[b;1];
    a=[0;1;-1];
    A=[A dvec(a*a')];
    %
    % Set up input data to call dsdp 5.8 (64 bits)
    %
    AC{1,1}='SDP';
    AC{1,2}=[3];
    AC{1,3}=[A C];
    OPTIONS.gaptol = 1.e-6;
    [STAT,y,X]=dsdp64(b,AC,OPTIONS);
    Y=dmat(X{1});
%