%======================================================
%  Matlab Demonstration of
%  Objective-Guided Rank-Reduction of SDP Relaxation for
%  3D kissing problem
%
%  Need to call public SDP solver SEDUMI
%
%  Input n = number of spheres.
%  Output: centers positions of n spheres.
%  
%  Details can be found in Sect. 6.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [Xx]=SDPkissing(n)
%
sl=80; %Slack variables
obj=2;
sl=sl+obj;
d=3; %Dimension
r=1;
r1=r;
t=2;
count = 1;
b=[];
%
%Comparison with center anchor - BASIC
%
for i = 1:n
    b=[b (2*r1)^2];
    a(:,count)=[zeros(n+sl,1)];
    a(i,count)=1;
    count=count+1;
end;
%
i1=count;%START INEQUALITIES NOW
%
%Comparison between the five remaining balls
%
for i = 1:(n)
    a(:,count)=zeros(n+sl,1);
    a(i,count)=1;
    a(mod(i,n)+1,count)=-1;
    count=count+1;
    b=[b (t*r)^2];
end;
%
i2=count;
%
for i = 1:n
    for j=(i+2):min(n+i-2,n)
    a(:,count)=zeros(n+sl,1);
    a(i,count)=1;
    a(j,count)=-1;
    count=count+1;
    b=[b (t*r)^2];
    end;
end;  
%
i3=count;
diff=i2-i1;
st=1;
%Create A matrix
A=[];
for i = 1:(count-1)
    temp=a(:,i)*a(:,i).';

    if i >= i1% & i < i2 
         temp(n+(i-i1)+1,n+(i-i1)+1)=-1;
    end;
    A=[A; vec(temp).'];
end;
b=b';
K.s=n+sl;
C=zeros(n+sl,n+sl);
cct=2;
% Construct SDP objective function according to n
if n ==3
    C(n+1:n+(i2-i1),n+1:n+(i2-i1))=-1*diag([1 1 1]);
elseif n == 4
      C(n+1:n+(i2-i1)+2,n+1:n+(i2-i1)+2)=-1*diag([0 0 0  0 1 1]);
elseif n == 5
   C(n+1:n+(i2-i1)+5,n+1:n+(i2-i1)+5)=1*diag([-1 -1 -1  -1 -1 0 0 0 0 0]);
elseif n == 6
      C(n+1:n+(i2-i1)+9,n+1:n+(i2-i1)+9)=-1*diag([1 1 1 1 1 1 0 1 0 0 0 1 1 0 0]);
elseif n == 7
      f1=[100 0 0.01 0.01 0.01 0.01 0.1];
      f2=[0.1 0.1 0.1 0.1  ];
      f3=[0 0 0 0 ];
      f4=[0 0 0.01 ];
      f5 = [0 0 ];
      f6=[0 ];    
      C(n+1:n+(i2-i1)+14,n+1:n+(i2-i1)+14)=-1*diag([f1 f2 f3 f4 f5 f6]);
elseif n == 8
      f1=[1 1 1 1 1 0 0.01 0.01];
      f2=[0 1 0 1  0.01];
      f3=[0 0 1 0 0];
      f4=[1 0 0 0];
      f5 = [0 0.01 0.01];
      f6=[0 0 ];
      f7=[0];   
      C(n+1:n+(i2-i1)+20,n+1:n+(i2-i1)+20)=-1*diag([f1 f2 f3 f4 f5 f6 f7]);
elseif n ==9
      f1=[1 0 0 0 0 0 0 0 -1];
      f2=[1 1 1 -1  -1 -1];
      f3=[1 0 1 0 0 0];
      f4=[1 0 1 0 0];
      f5 = [0 0 1 0];
      f6=[0 0 1];
      f7=[1 0];
      f8=[1];     
    c_temp=27;
    C(n+1:n+(i2-i1)+c_temp,n+1:n+(i2-i1)+c_temp)=-1*diag([f1 f2 f3 f4 f5 f6 f7 f8]);
elseif n ==10
      f1=[1 0 0 0 0 0 0 0 0 -1];
      f2=[1 1 1 1  -1 -1 -1];
      f3=[0 0 0 0 0 0 0];
      f4=[1 0 1 0 0 0];
      f5 = [1 0 1 0 0];
      f6=[0 0 1 0];
      f7=[0 0 1];
      f8=[1 0];
      f9=[1];
    c_temp=35;
    C(n+1:n+(i2-i1)+c_temp,n+1:n+(i2-i1)+c_temp)=-1*diag([f1 f2 f3 f4 f5 f6 f7 f8 f9]);  
elseif n==11;
    f1=[1 1 1 1 1 0 1 1 1 1 -1];
    f2=[1 1 1 1 -1 -1 -1 -1];%1 - 
    f3=[0 0 0 1 0 0 0 0];%2 - 
    f4=[0 0 0 1 0 0 0];%3 - 
    f5=[0 0 0 1 0 0];%4 - 
    f6=[0 0 0 1 0 ];%5 - 
    f7=[0 0 0 1 ];%6 - 
    f8=[0 0 1 ];%7 - 
    f9=[0 0 ];%8 - 
    f10=[0 ];%9 -    
    c_temp=44;
    C(n+1:n+(i2-i1)+c_temp,n+1:n+(i2-i1)+c_temp)=-1*diag([f1 f2 f3 f4 f5 f6 f7 f8 f9 f10]);
elseif n==12;      
    f1=[1 0 1 1 1 1 0 1 1 1 1 -1];
    f2=[1 1 1 1 1 -1 -1 -1 -1];%1 - 
    f3=[0 0 0 0 0 0 0 0 0];%2 - 
    f4=[0 0 1 1 0 0 0 0];%3 - 
    f5=[0 0 0 1 0 0 0 ];%4 - 
    f6=[0 0 0 1 0 0 ];%5 - 
    f7=[0 0 0 1 0 ];%6 - 
    f8=[0 0 0 1 ];%7 - 
    f9=[0 0  1];%8 - 
    f10=[0 0 ];%9 - 
    f11=[0 ];%10 -     
    C(n+1:n+(i2-i1)+54,n+1:n+(i2-i1)+54)=-1*diag([f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11]);   
end;
C=vec(C);
% Call SDP solver sedumi
[x,y1,info]=sedumi(A,b,C,K);
%
st=1:diff;
X=mat(x);
Y=X(1:n,1:n);
[V,D]=eig(Y);
Xx=sqrt(D)*V.';
%
sz=size(Xx);
% Plot the spheres
close all;
[X,Y,Z]=sphere(30); %Creates unit sphere (radius = 1);
surf(X,Y,Z);
hold on;
shading flat;
shading interp;
for i = 1:sz(1)
    surf(X-Xx(sz(1)-2,i),Y-Xx(sz(1)-1,i),Z-Xx(sz(1),i));
    hold on;
end;
%

