%======================================================
%  Matlab Demonstration of
%  Randomized Binary Rank-Reduction of SDP Relaxation for
%  a maxcut example (binary QP)
%
%  Need to call public SDP solver DSDP (64 bits)
%
%  Output: centers positions of n spheres.
%  
%  Details can be found in Sects. 6.2 and 6.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
%
    C=-dvec([3 0 0 -1 -1 -1;0 2 -1 0 -1 0;0 -1 1 0 0 0;-1 0 0 1 0 0;...
             -1 -1 0 0 2 0;-1 0 0 0 0 1]);
    %
    %
    b=ones(6,1);
    II=eye(6);
    a=II(:,1);
    A=dvec(a*a');
    for i=2:6
        a=II(:,i);
        A=[A dvec(a*a')];
    end
    %
    % Set up input data to call dsdp (64 bits)
    %
    AC{1,1}='SDP';
    AC{1,2}=[6];
    AC{1,3}=[A C];
    OPTIONS.gaptol = 1.e-6;
    [STAT,y,X]=dsdp64(b,AC,OPTIONS);
    Y=dmat(X{1});
    % binary rank-reduction
    R=chol(Y);
    x=sign(R'*randn(6,1))