%======================================================
%  One-Iteration demonstraition of the Primal-Dual
%  potential reduction algorithm for solving SDP
%      maximize    C*X
%      subject to  AX = b, X >=0
%  
%  Assume: both primal and dual have interior feasible solutions;
%          (rank-one) A_i=a_ia_i^T in primal form, i=1,...,m, 
%          where vector a_i is dimension n
%
%  Input 
%      A'  =[a_1, a_2, ..., a_m]
%      b: constraint right-hand column vector
%      C: objective symmetric matrix
%      X0: interior primal feasible solution
%      y0: interior dual feasible solution
%      iter (= 0): iteration count
%
%
%  Output
%      X: primal solution
%      (y,S): dual solution
%   Details can be found in Sect. 6.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if (iter == 0)
    [m,n]  = size(A);
    X=X0;
    y=y0;
    s=-A'*y;
    rho=2*n;
end;
%
gap     = vec(C)'*vec(X) - b'*y
S       = C-A'*diag(y)*A;
potenf  = rho*log(gap)-log(det(X))-log(det(S)) 
RX      = sqrtm(X);
D       = RX*S*RX;
D       = sqrtm(inv(D));
D       = RX*D*RX;
R       = chol(D);
B       = A*R';
M       = B*B';
Re      = (gap/rho)*inv(X)-S;
dy      = -(M.*M)\[diag(B*R*Re*R'*B')];
dS      = -A'*diag(dy)*A;
dX      = D*(Re-dS)*D;
V       = R*S*R';
V       = V*V;
V       = eig(V);
normpk  = (gap/rho)^2*sum(ones(n,1)./V)-(2*n/rho)*gap+gap;
normpk  = sqrt(normpk/min(V));
%
%  Update the the solutions
%
X       = X + (0.99/normpk)*dX;
y       = y + (0.99/normpk)*dy;
iter    = iter+1;
%


