%======================================================
%  Matlab demonstration of the regularized
%  linear regression with 1-norm (LASSO) 
%  regularizations (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2 + mu* sum |x(j)|
%
%  Algorithm: affine-scaling and steepest descent
%  Input 
%      A: Sparse constraint matrix.
%      b: the right-hand vector
%      x0:initial solution
%      mu: regularization weight
%  Output
%     x  : sparse solution
%  
%  Homework #7.17 and Algorithm in Sect. 8.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x]=L2L1regressionsg(A,b,x0,mu,maxiter)
if exist('mu') ~= 1 
   mu=0.1; 
end
if exist('maxiter') ~= 1 
   maxiter=5000; 
end
[m,n]=size(A);
ATA=A'*A;
beta=eigs(ATA,1)/2;
ee=ones(n,1);
%
% Compute L2L1 solution
x=x0;
%lambda=1;
iter=0;
while (iter < maxiter),
   iter=iter+1;
   % generate affine-scaled gradient for SDM
   dd = min(1, abs(x));
   gg = dd.*(A'*(A*x-b)+mu*sign(x));
   % 
   nora = max(abs(gg));
   % Set step-size 
   nora = min(1/beta, 1.3/nora);
   % Update solution
   x=x -nora*(dd.*gg);
 end;
 % end of the function