% This is a test program to compare the L_{1/2} and L_1
% norm-regularization to recover a regression solution
% in minimizing \|A*x-b\|^2 + mu\sum |x_j|^p
%
% Also compare the first and second order methods
% 
% Two ways to generate the test problems, each of which 
% has an available feasible to start with.
%
% Use matlab solvers L2Lxregressionsg and L2Lxregressiontr
%
% Homework #7.17 in Sect. 7.2 and Algorithms in Sect. 8.
% of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
% Test Problem Type 1
A=round(sprandn(30,60,.15));
A=[A -A];
% Generate a known sparse solution + or -
xx=round(5*sprandn(120,1,.15));
b=A*xx;
% Generate a dense feasible solution
x0=ones(120,1)+xx;
%
% Test Problem Type 2
%A=sprandn(30,120,.5);
%A=[A -A*ones(120,1)];
%xx=[round(10*sprandn(120,1,.12));0];
%x0=ones(121,1)+xx;
%b=A*x0;
%
% Run the first-order affine-scaling method with
% L1-norm regularization
x=L2L1regressionsg(A,b,x0,0.3);
x11=sign(x).*max(abs(x)-1.e-2,0);
%
% Using the first-order affine-scaling method with
% L_half-norm regularization
x=L2Lxregressionsg(A,b,x0,0.3);
xh1=sign(x).*max(abs(x)-1.e-2,0);
%
% Using the second-order trust-region method with
% L_half-norm regularization
[x,evmin]=L2Lxregressiontr(A,b,x0,0.3);
xh2=sign(x).*max(abs(x)-1.e-2,0);
% 
% Show results
%
[full(xx) x11 xh1 xh2]
% 
