%======================================================
% Optimal Pricing:
% Simulation to compare dynamic pricing vs fixed pricing 
% under the demand model: q=exp(a*log(p)+b)
%      a=-2 is the price elasticity coefficient
%      b is the externality coefficient
%      c is the given unit cost, 
%      fixed optimal price: p=ca/(1+a).
%
%  Supplemental optimization example for Chapter 7 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
% 
p=zeros(1000,1);
q=zeros(1000,1);
%
% Case 1 random elasticity
%
%a=-2*ones(1000,1)+0.1*randn(1000,1);
%
% Case 2 two-level random elasticity
%
%a(1:500)=-2*ones(500,1)-0.5*rand(500,1);
%a(501:1000)=-2*ones(500,1)+0.5*rand(500,1);
%
% Case 3 cyclic elasticity
for k=1:1000;
    a(k)=-2-0.5*sin(0.01*k)+0.1*randn;
end;
%
b=15;
c=100;
p(1)=200;
drev=0;
 for k=1:1000,
  % observe the demand
  q(k)=exp(a(k)*log(p(k))+b);
  % compute accumulated profit
  drev=drev+(p(k)-c)*q(k);
  % recompute the elasticity against the default
  ak=(log(q(k))-b)/log(p(k));
  % optimally choose price according to new elasticity
  p(k+1)=c*ak/(1+ak);
 end;
 frev=0;
 for k=1:1000,
  % observe the demand
  q(k)=exp(a(k)*log(p(k))+b);
  % compute accumulated profit
  frev=frev+(p(k)-c)*q(k);
  % keep default optimal price
  p(k+1)=200;
 end;
 [drev frev]
%         
%