%======================================================
% Optimal Pricing:
% Simulation to compare dynamic pricing vs fixed pricing 
% under the demand model: q=exp(a*p+b)
%      a is the price elasticity coefficient
%      b is the externality coefficient
%      c is the given unit cost, 
%      fixed optimal price: p=c-1/a.
%
%  Supplemental optimization example for Chapter 7 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
% 
p=zeros(1000,1);
q=zeros(1000,1);
%
% Case 1 random elasticity
%
%a=-0.1*(ones(1000,1)-0.2*randn(1000,1));
%
% Case 2 two-level random elasticity
%
a=zeros(1000,1);
a(1:500)=-0.1*(ones(500,1)-0.3*rand(500,1));
a(501:1000)=-0.1*(ones(500,1)+0.3*rand(500,1));
%
% Case 3 cyclic elasticity
%for k=1:1000;
%    a(k)=-0.1*(1-0.3*sin(0.01*k));
%end;
%
b=16;
c=100;
p(1)=110;
drev=0;
 for k=1:1000,
  % observe the demand
  q(k)=exp(a(k)*p(k)+b);
  % compute accumulated profit
  drev=drev+(p(k)-c)*q(k);
  % recompute the elasticity against the default
  ak=-0.1+log(q(k)/exp(-0.1*p(k)+b))/p(k);
  % optimally choose price according to new elasticity
  p(k+1)=c-1/ak;
 end;
 frev=0;
 for k=1:1000,
  % observe the demand
  q(k)=exp(a(k)*p(k)+b);
  % compute accumulated profit
  frev=frev+(p(k)-c)*q(k);
  % keep default optimal price
  p(k+1)=110;
 end;
 [drev frev]
%         
%