%======================================================
%  Matlab implementation of the stochastic-gradient
%  descent method for linear least-squares
%  (Update one block in each iteration)
%  
%      minimize    \|Ax-b\|^2
%
%  Input Data
%      A: m x n matrix
%      b: vector
%      mb: number of batches
%  
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 8.8 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
%
function [x]=CyclicSGDlls(A,b,mb,maxiter,toler)
if exist('maxiter') ~= 1 
   maxiter=500; 
end
if exist('toler') ~= 1 
   toler=1.e-3; 
end
tic
[m,n]=size(A);
x=zeros(n,1);
mv=floor(m/mb);
% set initial residual vector
Axb=A*x-b;
beta=norm(A(1,:)'*Axb(1))*sqrt(mv);
%
iter=0;
for k=1:maxiter,
  % Sample the gradient following a random order
  rp=randperm(mb);
  for ii=1:mb,
     % Find mv variable and form a batch
     ra=[(rp(ii)-1)*mv+1:rp(ii)*mv];
     % construct sub-A matrix according to the batch
     Ap=A(ra,:);
     % find the corresponding gradient and update x
     dd=-(1/(beta*sqrt(k)))*(Ap'*Axb(ra));
     x=x+dd;
     % updat the residual
     Axb=A*x-b;
     % Check stopping criteria
     if norm(A'*Axb)<toler, break, end;
     % Go to the next batch
  end;
  % Go to the next iteration
  iter=iter+1;
end;
toc
iter=iter
%   