%======================================================
%  Matlab Demonstration of the Newton step
%  for the system of nonlinear equation in Lecture Note
%  x(2)-log(x(1))=0 and x(1)^2+x(2)^2-1=0
%  
%   Method can be found in Sect. 8.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
f=[x(2)-log(x(1));x(1)^2+x(2)^2-1]
jacob=[-1/x(1) 1;2*x(1) 2*x(2)]
x=x-(jacob\f)
%