%======================================================
%  Matlab implementation of the randomized block-coordinate
%  method for linear least-squares
%  (Randomly assemble a block and update it in each iteration)
%  
%      minimize    \|Ax-b\|^2
%
%  Input Data
%      A: m x n matrix
%      b: vector
%      nb: number of blocks such that n divided
%          by nb is an integer)
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 8.8 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
%
function [x]=RABCDglls(A,b,nb,maxiter,toler)
if exist('maxiter') ~= 1 
   maxiter=500; 
end
if exist('toler') ~= 1 
   toler=1.e-3; 
end
beta=max(eigs(A'*A))/nb
tic
[m,n]=size(A);
x=zeros(n,1);
nv=floor(n/nb);
% set initial residual vector
Axb=A*x-b;
%
iter=0;
for k=1:maxiter,
  % Randomly select nv variable and form a block
  ra=randperm(n);
  ra=ra(1:nv);
  % construct sub-A matrix according to the block
  Ap=A(:,ra);
  % substract them from the residual 
  Axb=Axb-Ap*x(ra);
  % update the block
  x(ra)=-Ap\Axb;
  % add updated block back to the residual
  Axb=Axb+Ap*x(ra);
  % Check stopping criteria
  if norm(A'*Axb)<toler, break, end;
  % Go to the next iteration
  iter=iter+1;
end;
toc
iter=iter
%   