%======================================================
%  Matlab implementation of the randomized block-coordinate
%  gradient/descent method for linear least-squares
%  (Randonly select a block and update it in each iteration)
%  
%      minimize    \|Ax-b\|^2
%
%  Input Data
%      A: m x n matrix
%      b: vector
%      nb: number of blocks such that n divided
%          by nb is an integer)
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 8.8 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
%
function [x]=RandBCDglls(A,b,nb,maxiter,toler)
if exist('maxiter') ~= 1 
   maxiter=500; 
end
if exist('toler') ~= 1 
   toler=1.e-3; 
end
beta=max(eigs(A'*A))/nb
tic
[m,n]=size(A);
x=zeros(n,1);
nv=floor(n/nb);
% set initial residual vector
Axb=A*x-b;
%
iter=0;
for k=1:maxiter,
  % Update x for a randomly slected block
  rp=randperm(nb);
  % find the variable indexes of the selected block
  il=(rp(1)-1)*nv+1;
  iu=il+nv-1;
  % construct sub-A matrix according to the block
  Ap=A(:,il:iu);
  % find the corresponding gradient and update them
  dd=-(1/beta)*(Ap'*Axb);
  x(il:iu)=x(il:iu)+dd;
  % updat the residual
  Axb=Axb+Ap*dd;
  % Check stopping criteria
  if norm(A'*Axb)<toler, break, end;
  % Go to the next iteration
  iter=iter+1;
end;
toc
iter=iter
%   