%======================================================
%  Matlab implementation of the affine-scaling steepest
%  descent method for strongly convex quadratic minim.
%  
%      minimize    0.5x'Qx+c'x   s.t. x>=0
%
%  Input Data
%      Q: symmetric PD matrix
%      c: vector
%      x0: any initial solution
%  Output
%      x: latest iterative solution
%
%  Step size is set no more than the scaled Lipschhtz number 
%  while keep each iterate no more than a 5% away from zero.
%  Details can be found in Sect. 8.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if exist('beta') ~= 1
   beta=max(eig(Q));   
end
if exist('maxiter') ~= 1 
   maxiter=100; 
end
if exist('x0') ~= 1 
  [m,n] = size(Q);
  x0=ones(n,1);
end
x=x0;
g=(Q*x+c);
norm(x.*g)
for k=1:maxiter,
  xg=x.*g;
  alpha=max(xg);
  if alpha < 0, alpha=1; end;
  % step size to keep iterate in the interior
  alpha=min([0.95/alpha 2/(max(x)^2*beta)]);
  x=x - alpha*(x.*xg);
  g=(Q*x+c);
end;
norm(x.*g)
% 