%======================================================
%  Matlab implementation of the mirror steepest descent
%  method for strongly convex quadratic minimization
%  
%      minimize    0.5x'Qx+c'x   s.t. x>=0
%
%  Input Data
%      Q: symmetric PD matrix
%      c: vector
%      x0: any initial solution
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 8.5 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
if exist('beta') ~= 1
   beta=max(eigs(Q));   
end
if exist('maxiter') ~= 1 
   maxiter=100; 
end
if exist('x0') ~= 1 
  [m,n] = size(Q);
  x0=ones(n,1);
end
x=x0;
g=(Q*x+c);
norm(x.*g)
for k=1:100,
  x=x.*exp(-(2/beta)*g);
  g=(Q*x+c);
end;
norm(x.*g)
% 