%======================================================
%  Matlab implementation of the conjugate gradient 
%  method for convex quadratic minimization
%  
%      minimize    0.5x'Qx+c'x
%
%  Input Data
%      Q: symmetric PSD matrix
%      c: vector
%      x0: any initial solution
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 9.3 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
[m,n]=size(Q);
x=x0;
norm(Q*x+c)
g=(Q*x+c);
d=-g;
for k=1:n,
  alpha=-(g'*d)/(d'*(Q*d));
  % or use line search for alpha
  x=x+alpha*d;
  gg=(Q*x+c);
  %beta1=(gg'*gg)/(g'*g);
  beta1=(gg'*(gg-g))/(g'*g);
  d=-gg+beta1*d;
  g=gg;
end;
norm(g)
% 