%======================================================
%  Matlab function of the conjugate
%  gradient method for convex quadratic minimization
%  (Matlab pcg function)
%  
%      minimize    0.5x'Qx+c'x
%
%  Input Data
%      Q: symmetric PSD matrix
%      c: vector
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 9.3 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
%
[m,n]=size(Q);
norm(Q*x0+c)
tic
x=pcg(Q,-c,1.e-6,n,eye(n),eye(n),x0);
norm(Q*x+c)
toc
% 