%======================================================
%  Matlab demonstration of the preconditioned conjugate
%  gradient method against the regular sdm
%  for linear least squares regression
%  
%      minimize    \|A*x-b\|^2
%
%  Input Data
%      A: mxn-matrix
%      b: m-vector
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 9.6 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
[m,n]=size(A);
% Build a precondition matrix based on previous
% m-2 data points
Ap=A(1:(m-2),:);
R=chol(Ap'*Ap);
% Form the quadratic minimization problem
Q=A'*A;
c=A'*b;
x0=randn(n,1);
norm(A*x0-b)
tic;
% Call matlab preconditioned CG solver with 
% th eprecondition matrix
xpcg=pcg(Q,c,1.e-6,1000,R',R,x0);
pcgerror=norm(A*xpcg-b)
pcgt=toc
% Call matlab preconditioned CG solver without
% preconditioners
tic;
xcg=pcg(Q,c,1.e-6,1000,speye(n),speye(n),x0);
cgerror=norm(A*xcg-b)
cgt=toc
% 