%======================================================
%  Matlab demonstration of the steepest descent
%  method for linear least-squares regression
%  
%      minimize    \|A*x-b\|^2
%
%  Input Data
%      A: mxn-matrix
%      b: m-vector
%  Output
%      x: latest iterative solution
%
%   Details can be found in Sect. 9.7 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
x=x0;
tic
g=A'*(A*x-b);
norm(g)
beta=eigs(A'*A,1);
for k=1:100,
  x=x-(1/beta)*g;
  g=A'*(A*x-b);
end;
sdmerror=norm(g)
sdmt=toc
% Steepest Descent Method for minmizing |Ax-b| with the step size 1/beta
%             ( needs beta sufficiently large )
%
%      minimize    0.5x'*Q*x+c'*x
%