%======================================================
%  Matlab demonstration of solving Fisher social 
%  optimizarion with the logarithmic barrier function
%      maximize  5ln(2x1+x3)+8ln(3x2+x4)+mu\sum\ln(x_j) 
%      s.t.      x1 + x2 =1
%                x3 + x4 =1
%  
%  Algorithm: first-order path-following with 
%             Gradient-Projection method 
%  Output  x: good allocation, y: prices of goods
%
%  Problem can be found from Example 3 in Sect. 11.6
%  GPM in Sect.12.3 and Barrier method in Sect. 13.2
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%  
% 
A=[1 1 0 0;0 0 1 1];
AINV=inv(A*A');
b=[1;1];
mu=10;
alpha=0.5;
% Start from the analytic center 
x=[1/2;1/2;1/2;1/2];
% Barrier path-following iteration
for i=1:15, 
% The gradient-projection iteration for fixed mu
for k=1:100,
g=[10/(2*x(1)+x(3));24/(3*x(2)+x(4));5/(2*x(1)+x(3));8/(3*x(2)+x(4))];
g=g+mu./x;
y=AINV*(A*g);
d=g-A'*y;
% Take a step size to keep solution in the interior
x=x+(alpha/norm(d./x))*d;
end;
% End of a major iteration and then reduce mu 
mu=mu/2;
end;
x,
y,
% 