% This program solves the linearly constrained non-convex
% program 
%
% min   0.5x^TQx+c^Tx+mu(\sum x_j^{.5})
% s.t.  e^Tx = 1, x >= 0.
%
% via sequential (first-order) linear programming or 
% gradient projecton with affine-scaling
%
%  Input 
%      Q: covariance matrix
%      c: expectation vector
%      mu: regularization weight factor
%     
%  Output
%     x>=0  : feasible solution: Ax = b,
%     y     : Lagrange multiplier
%  
%  Output
%     x>=0  : (sparse) portfolio solution e^Tx=1 
%  
%  Example 1 in Sect. 11.6 and Algorithm in Sect. 12.2-3
%  of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,y,iter]=Halfnormport1st(Q,c,mu,toler,alpha)
if exist('mu') ~= 1
  mu = 0.1;
end;
if exist('toler') ~= 1
  toler = 1.e-4;
end;
if exist('alpha') ~= 1
  alpha = 0.5;
end;
 [m,n]=size(Q);
 x  = ones(n,1)/n;
 gap=1;
 iter=0;
 A=ones(1,n);
%
%  Repeatly solving the affine scaling direction problem
%
 while (gap >= toler) & (iter < 501),
   % generate affine-scaled direction
   gg = -x.*(Q*x+c)-(mu/2)*sqrt(x);
   DD = sparse(1:n,1:n,x,n,n);
   AD = A*DD;
   y = [speye(n) AD';AD 0]\[gg;0];
   dd = y(1:n);
   y = -y(n+1);
   iter=iter+1;
   % compute the residual of the projected gradient
   gap=norm(dd);
   % compute step size to stay in the interior
   nora = min(dd);
   nora = abs(alpha/nora);
   %
   % Update iterates
   %
   x = x + nora*(x.*dd);
 end;
 % end