% This is a test program to compare different first 
% and second order methods for the sparse L_{1/2} 
% regularized mean-variace model of portfolio 
% optimization problem  
%
%     min  0.5x'*Qx+c'*x, s.t. e^Tx=1, x>=0
% 
%
% Use matlab solvers 
% Halfnormport1st (first-order, gradient projection)
% Halfnormport2ndQ (second-order but ignore the concave
%                   part in Hessian)
% Halfnormport2ndQ (second-order, indefinite full Hessian)
%                                       
% Example 1 in Sect. 11.6 and Algorithm in Sect. 12.2-3
% and Sect. 12.7 of L&Y, Linear and nonlinear programming, 
% 5th edition
%======================================================% 
% Generate test data
Q=round(sprandn(30,50,.5));
Q=Q'*Q;
c=-rand(50,1);
%
% Run first-order minimization
%
[x1,y,it1]=Halfnormport1st(Q,c,0.1);
%
% Run second-order with partial Hessian 
%
[x2Q,y,it2Q]=Halfnormport2ndQ(Q,c,0.1);
%
% Run second-order with full Hessian 
%
[x2H,y,it2H]=Halfnormport2ndH(Q,c,0.1);
% 
% Show results
%
[max(x1-1.e-3,0) max(x2Q-1.e-3,0) max(x2H-1.e-3,0)]
% 
