%======================================================
% Matlab demonstration of solving linear regression 
% with the cardinality constraint (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2
%       s.t. x>=0, |supp(x)|\le cm
%
%  Algorithm: steepest-descent-cardinality-projection
%  Input 
%      A:  Sparse constraint matrix.
%      b:  the right-hand vector
%      x0: initial solution
%      cm: the up-limit of nonzero entries
%  Output
%     x   : solution from steepest descent card-projection
%
%   Problem can be found in homework #7.17 of Sect. 7.2 
%   and Algorithm in Sect. 12.1 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x]=L2L1nnregressionsdcardi(A,b,x0,cm,maxiter,toler)
if exist('cm') ~= 1 
   cm=5; 
end
if exist('maxiter') ~= 1 
   maxiter=1000; 
end
if exist('toler') ~= 1
  toler = 1.e-4;
end;
[m,n]=size(A);
ATA=A'*A;
beta=eigs(ATA,1);
% 
x=x0;
iter=0;
while (iter < maxiter),
   iter=iter+1;
   % generate gradient 
   gg = (A'*(A*x-b));
   % update x
   xx=x - (1/beta)*gg;
   [xx,ix]=sort(xx,'descend');
   x=zeros(n,1);
   x(ix(1:cm))=xx(1:cm);
end;
% end of the function