%======================================================
% Matlab demonstration of solving linear regression 
% with the 0.5-norm regularizations (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2 + mu* sum |x(j)|
%       s.t. x>=0
%
%  Algorithm: steepest-descent-projection
%  Input 
%      A: Sparse constraint matrix.
%      b: the right-hand vector
%      mu: regularization weight
%  Output
%     x   : solution from steepest descent projection
%
%   Problem can be found in homework #7.17 of Sect. 7.2 
%   and Algorithm in Sect. 12.1 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x]=L2L1nnregressionsdproj(A,b,mu,maxiter,toler)
if exist('mu') ~= 1 
   mu=0.1; 
end
if exist('maxiter') ~= 1 
   maxiter=1000; 
end
if exist('toler') ~= 1
  toler = 1.e-4;
end;
[m,n]=size(A);
ATA=A'*A;
beta=eigs(ATA,1);
% 
x=ones(n,1);
iter=0;
while (iter < maxiter),
   iter=iter+1;
   % generate gradient 
   gg = (A'*(A*x-b))+(mu/2)*sign(x);
   % update x
   x=x - (1/beta)*gg;
   x=max(0,x);
end;
% end of the function