% This is a test program to compare the L_{1/2} and L_1
% norm-regularization to recover a regression solution
% in minimizing \|A*x-b\|^2 + mu\sum |x_j|^p, s.t. x>=0
%
% Also compare the first and second order methods
% 
% Two ways to generate the test problems, each of which 
% has an available feasible to start with.
%
% Use matlab solvers L2L1nnregressionsdproj 
%                    L2L1nnregressionsdcardi
%                    L2Lpnnregressionsdproj  and 
%                    L2Lpnnregressiontr
%
% Homework #7.17 with nonnegative onstraint in Sect. 7.2 
% and Algorithms in Sect. 12.1 and 12.7
% of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
% Test Problem Type 1
A=round(sprandn(30,60,.15));
A=[A -A];
% Generate a known sparse solution + or -
xx=round(5*sprand(120,1,.15));
b=A*xx;
%
% Test Problem Type 2
%A=sprandn(30,120,.5);
%A=[A -A*ones(120,1)];
%xx=[round(10*sprandn(120,1,.12));0];
%
% Run the first-order SD nonnegative projecton 
% method with L1-norm regularization
x11=L2L1nnregressionsdproj(A,b,0.1);
%
% Run the first-order SD nonnegative-cadinality 
% projection method with L1-norm regularization
xc1=L2L1nnregressionsdcardi(A,b,0.1,15);
%
% Using the first-order SD nonnegative projection
% method with L_half-norm regularization
xp1=L2Lpnnregressionsdproj(A,b,0.1);
%
% Using the second-order trust-region method with
% L_half-norm regularization
[xp2,evmin]=L2Lpnnregressiontr(A,b,0.1);
% 
% Show results
%
[full(xx) x11 xc1 xp1 xp2]
% 
