%======================================================
% Matlab demonstration of solving linear regression 
% with the 0.5-norm regularizations (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2 + mu* sum |x(j)|^{0.5}
%       s.t. x>=0
%
%  Algorithm: intrior-trust-region method
%  Input 
%      A: Sparse constraint matrix.
%      b: the right-hand vector
%      mu: regularization weight
%  Output
%     x   : solution from steepest descent projection
%
%   Problem can be found in homework #7.17 of Sect. 7.2 
%   and Algorithm in Sect. 12.7 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,evmin]=L2Lpnnregressiontr(A,b,mu,maxiter,toler)
if exist('mu') ~= 1 
   mu=0.1; 
end
if exist('maxiter') ~= 1 
   maxiter=30; 
end
if exist('toler') ~= 1
  toler = 1.e-4;
end;
[m,n]=size(A);
ATA=A'*A;
lam=10;
% 
x=ones(n,1);
iter=0;
while (iter < maxiter),
   iter=iter+1;
   % generate affine-scaled gradient and Hessian and 
   % apply the trust-region method
   DD = diag(x);
   gg = -DD*(A'*(A*x-b))-(mu/2)*sqrt(x);
   HH = DD*ATA*DD-(mu/4)*diag(sqrt(x));
   evmin=min(eig(HH))
   if (evmin > 0), evmin=0, end;
   dd = (HH+(abs(evmin)+lam)*eye(n))\gg;
   % Set the step size
   nora = min(dd);
   nora = abs(0.75/nora);
   %
   % Update iterates
   %
   x = x + nora*(x.*dd);
   lam=lam/1.5;
end;
x=max(x-0.01,0);
% end of the function