%======================================================
%  Matlab demonstration of solving Fisher social 
%  optimizarion with the logarithmic barrier function
%      maximize  5ln(2x1+x3)+8ln(3x2+x4)+mu\sum\ln(x_j) 
%      s.t.      x1 + x2 =1
%                x3 + x4 =1
%  
%  Algorithm: Second-order path-following with 
%             Newton's interior-point method 
%  Output  x: good allocation, y: prices of goods
%
%  Problem can be found from Example 3 in Sect. 11.6
%  Newton Lograthmic Barrier method in Sect. 13.4
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%  
% 
% 
A=[1 1 0 0;0 0 1 1];
[m,n]=size(A);
b=[1;1];
mu=10;
x=[2/5;3/5;1/2;1/2];
y=[0;0];
tic
for k=1:15,
    u1=2*x(1)+x(3);
    u2=3*x(2)+x(4);
    g=[-10/u1;-24/u2;-5/u1;-8/u2];
    g=g-mu./x;
    g=[g-A'*y;A*x-b];
    H=[20/(u1)^2 0 10/(u1)^2 0;0 72/(u2)^2 0 24/(u2)^2;...
       10/(u1)^2 0 5/(u1)^2  0;0 24/(u2)^2 0 8/(u2)^2];
    H=H+diag(mu./(x.^2));
    [H -A';A zeros(2,2)]\g;
    x=x-ans(1:4);
    y=y-ans(5:6);
    % reduce mu
    mu=mu/2;
end;
time=toc
x,
-y,
%