%======================================================
%  Matlab implementation of the project steepest descent
%  method for box-constrained qp
%  
%      minimize    0.5x'Qx+c'x   s.t. 0 <= x <= 1
%
%  Input Data
%      Q: symmetric matrix
%      c: vector
%      maxiter: maximum number of iterations (optional)
%      beta: Lipchitz constant (optional)
%  Output
%      x: latest iterative solution
%
%   Algorithm details can be found in Sect. 12.1 of
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x]=SDprojboxqp(Q,c,maxiter,beta)
%
if exist('maxiter') ~= 1 
   maxiter=500; 
end
if exist('beta') ~= 1
   beta=abs(eigs(Q,1));   
end
%
[m,n]=size(Q);
x=ones(n,1)/2;
x = x + 0.01*rand(n,1);
%
for k=1:maxiter,
  % compute the gradient
  g=(Q*x+c);
  % make steepest-descent and then projection 
  x=min(max(0, x-(1/beta)*g),1);
end;
% 